package unitTest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.junit.Test;

import com.google.common.collect.Lists;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.struct.LPNET_SDK_DEVICEINFO;
import netsdk.struct.NET_SDK_FACE_INFO_IMG_DATA;
import netsdk.struct.NET_SDK_FACE_INFO_IMG_GET;
import netsdk.struct.NET_SDK_FACE_MATCH_ALARM;
import netsdk.struct.NET_SDK_FACE_MATCH_ALARM_TRIGGER;
import netsdk.struct.NET_SDK_SEARCH_IMAGE_BY_IMAGE;
import netsdk.struct.NET_SDK_SEARCH_IMAGE_BY_IMAGE_LIST;
import netsdk.struct.NET_SDK_SEARCH_IMAGE_ITEM;

public class NET_SDK_FaceMatchOperate_Test3 {
	/**
	 * 获取比对报警联动 单元测试
	 * @Title: NET_SDK_GET_FACE_MATCH_ALARM_Test
	 * @Description: TODO
	 * @throws Throwable
	 * @return: void
	 */
	//@Test
	public void NET_SDK_GET_FACE_MATCH_ALARM_Test() throws Throwable {
		Boolean initResult = CommonFunctions.init();
		if (!initResult)
			return;
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		NET_SDK_FACE_MATCH_ALARM sOut = new NET_SDK_FACE_MATCH_ALARM();
		Memory lpOutBuffer = new Memory(100 * 1024);
		// CommonFunctions.SetStructDataToPointer(sOut, lpOutBuffer, 0);
		//Memory lpBytesReturned = new Memory(4);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 10, null, 0, lpOutBuffer,
				(int) lpOutBuffer.size(), lpBytesReturned);
		if (!bResult) {
			throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
		}
		CommonFunctions.GetPointerDataToStruct(lpOutBuffer, 0, sOut);
		NET_SDK_FACE_MATCH_ALARM_TRIGGER[] items = new NET_SDK_FACE_MATCH_ALARM_TRIGGER[sOut.faceFeatureGroupsNum];
		for (int i = 0; i < items.length; i++) {
			items[i] = new NET_SDK_FACE_MATCH_ALARM_TRIGGER();
		}

		System.out.println("目标组联动信息个数" + sOut.faceFeatureGroupsNum);
		System.out.println("相似度" + sOut.similarity);
//		System.out.println(sOut.FaceMatchChanGroup[1].faceFeatureGroupIDs);
		System.out.println(Arrays.asList(sOut.FaceMatchChanGroup[0].faceFeatureGroupIDs));
		CommonFunctions.GetPointerDataToStructArr(sOut.sFaceMatchAlarmTrigger, items);
		for (NET_SDK_FACE_MATCH_ALARM_TRIGGER item : items) {
			System.out.println(String.format("人脸比对报警==> groupId:%s,groupSwitch:%s,alarmOutSwitch:%s", item.groupId,
					item.groupSwitch, item.alarmOutSwitch));
			System.out.println(String.format(
					"人脸比对报警==> msgPushSwitch:%s,buzzerSwitch:%s,popMsgSwitch:%s,emailSwitch:%s", item.msgPushSwitch,
					item.buzzerSwitch, item.popMsgSwitch, item.emailSwitch));
			Pointer p= item.getPointer();
			Native.free(Pointer.nativeValue(p));//手动释放内存  
			Pointer.nativeValue(p, 0);
		}
		
		Pointer p= sOut.getPointer();
		Native.free(Pointer.nativeValue(p));//手动释放内存  
		Pointer.nativeValue(p, 0);
		
		Native.free(Pointer.nativeValue(lpOutBuffer));//手动释放内存  
		Pointer.nativeValue(lpOutBuffer, 0);
		
//		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
//		Pointer.nativeValue(lpBytesReturned, 0);
	}
	/**
	 * 获取比对报警联动
	 * @Title: NET_SDK_GET_FACE_MATCH_ALARM
	 * @Description: TODO
	 * @param lUserID 用户ID
	 * @return
	 * @throws Throwable
	 * @return: NET_SDK_FACE_MATCH_ALARM 比对报警联动信息
	 */
	public NET_SDK_FACE_MATCH_ALARM NET_SDK_GET_FACE_MATCH_ALARM(NativeLong lUserID) throws Throwable {
		NET_SDK_FACE_MATCH_ALARM sOut = new NET_SDK_FACE_MATCH_ALARM();
		Memory lpOutBuffer = new Memory(100 * 1024);
		// CommonFunctions.SetStructDataToPointer(sOut, lpOutBuffer, 0);
		//Memory lpBytesReturned = new Memory(4);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 10, null, 0, lpOutBuffer,
				(int) lpOutBuffer.size(), lpBytesReturned);
		if (!bResult) {
			throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
		}
		CommonFunctions.GetPointerDataToStruct(lpOutBuffer, 0, sOut);
		NET_SDK_FACE_MATCH_ALARM_TRIGGER[] items = new NET_SDK_FACE_MATCH_ALARM_TRIGGER[sOut.faceFeatureGroupsNum];
		for (int i = 0; i < items.length; i++) {
			items[i] = new NET_SDK_FACE_MATCH_ALARM_TRIGGER();
		}
		CommonFunctions.GetPointerDataToStructArr(sOut.sFaceMatchAlarmTrigger, items);
		for (NET_SDK_FACE_MATCH_ALARM_TRIGGER item : items) {
			System.out.println(String.format("人脸比对报警==> groupId:%s,groupSwitch:%s,alarmOutSwitch:%s", item.groupId,
					item.groupSwitch, item.alarmOutSwitch));
			System.out.println(String.format(
					"人脸比对报警==> msgPushSwitch:%s,buzzerSwitch:%s,popMsgSwitch:%s,emailSwitch:%s", item.msgPushSwitch,
					item.buzzerSwitch, item.popMsgSwitch, item.emailSwitch));
		}
		Native.free(Pointer.nativeValue(lpOutBuffer));//手动释放内存  
		Pointer.nativeValue(lpOutBuffer, 0);
		
//		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
//		Pointer.nativeValue(lpBytesReturned, 0);
		return sOut;
	}
	/**
	 * 设置比对报警联动 单元测试
	 * @Title: NET_SDK_SET_FACE_MATCH_ALARM_Test
	 * @Description: TODO
	 * @throws Throwable
	 * @return: void
	 */
	//@Test
	public void NET_SDK_SET_FACE_MATCH_ALARM_Test() throws Throwable {
		Boolean initResult = CommonFunctions.init();
		if (!initResult)
			return;
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		NET_SDK_FACE_MATCH_ALARM alarm = NET_SDK_GET_FACE_MATCH_ALARM(lUserID);
		
		alarm.similarity = 20;
		Memory lpInBuffer = new Memory(alarm.size());
		CommonFunctions.SetStructDataToPointer(alarm, lpInBuffer, 0);
		//Memory lpBytesReturned = new Memory(4);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 11, lpInBuffer, (int) lpInBuffer.size(),
				null, 0, lpBytesReturned);
		if (!bResult) {
			throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
		}
		Native.free(Pointer.nativeValue(lpInBuffer));//手动释放内存  
		Pointer.nativeValue(lpInBuffer, 0);
		
//		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
//		Pointer.nativeValue(lpBytesReturned, 0);
		
		Pointer p= alarm.getPointer();
		Native.free(Pointer.nativeValue(p));//手动释放内存  
		Pointer.nativeValue(p, 0);
	}
	/**
	 * 获取目标数据 单元测试
	 * @Title: NET_SDK_GET_FACE_INFO_IMG_Test
	 * @Description: TODO
	 * @throws Throwable
	 * @return: void
	 */
	@Test
	public void NET_SDK_GET_FACE_INFO_IMG_Test() throws Throwable {
		Boolean initResult = CommonFunctions.init();
		if (!initResult)
			return;
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		int itemId = 13626;// 目标ID，
		NET_SDK_FACE_INFO_IMG_GET sIn = new NET_SDK_FACE_INFO_IMG_GET();
		NET_SDK_FACE_INFO_IMG_DATA sOut = new NET_SDK_FACE_INFO_IMG_DATA();
		sIn.index = 1;
		sIn.itemId = itemId;
		Memory lpInBuffer = new Memory(sIn.size());
		CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
		sOut.write();
		Memory lpOutBuffer = new Memory(100 * 1024);
		//Pointer lpBytesReturned = new Memory(4);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 12, lpInBuffer, (int) lpInBuffer.size(),
				lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned);
		if (!bResult) {
			throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
		}
		CommonFunctions.GetPointerDataToStruct(lpOutBuffer, 0, sOut);
		System.out.println("len: " + lpBytesReturned.getValue());
		System.out.println(String.format("获取目标数据==> imgLen：%s, imgData:%s", sOut.imgLen, sOut.imgData));

		byte[] data = sOut.imgData.getByteArray(0, sOut.imgLen);

		try {
			CommonFunctions.writeFileByBytes("./person.jpg",data,false);//数据写入文件中
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
//		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
//		Pointer.nativeValue(lpBytesReturned, 0);
		
		Native.free(Pointer.nativeValue(lpOutBuffer));//手动释放内存  
		Pointer.nativeValue(lpOutBuffer, 0);
		
		Native.free(Pointer.nativeValue(lpInBuffer));//手动释放内存  
		Pointer.nativeValue(lpInBuffer, 0);
		
		Native.free(Pointer.nativeValue(sIn.getPointer()));//手动释放内存  
		Pointer.nativeValue(sIn.getPointer(), 0);
		
		Native.free(Pointer.nativeValue(sOut.getPointer()));//手动释放内存  
		Pointer.nativeValue(sOut.getPointer(), 0);
	}
	/**
	 * 以图搜图 单元测试
	 * @Title: NET_SDK_SEARCH_IMAGE_BY_IMG_Test
	 * @Description: TODO
	 * @throws Throwable
	 * @return: void
	 */
	//@Test
	public void NET_SDK_SEARCH_IMAGE_BY_IMG_Test() throws Throwable {
		Boolean initResult = CommonFunctions.init();
		if (!initResult)
			return;
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		NET_SDK_SEARCH_IMAGE_BY_IMAGE sIn = new NET_SDK_SEARCH_IMAGE_BY_IMAGE();
		sIn.pageIndex = 1;
		sIn.pageSize = 20;
		sIn.similarity = 70;
		sIn.resultCountLimit = 20;
		sIn.searchType = 4;
		sIn.startTime.year = 2018;
		sIn.startTime.month = 7;
		sIn.startTime.mday = 10;
		sIn.startTime.hour = 10;
		sIn.startTime.minute = 0;
		sIn.startTime.second = 0;
		sIn.endTime.year = 2018;
		sIn.endTime.month = 7;
		sIn.endTime.mday = 20;
		sIn.endTime.hour = 10;
		sIn.endTime.minute = 0;
		sIn.endTime.second = 0;
		File saveFile = new File("D:\\1.jpg");
		FileInputStream saveInputStream = new FileInputStream(saveFile);
		long facePicSize = saveFile.length();
		Memory imgData = new Memory(facePicSize);
		imgData.clear();
		if (!CommonFunctions.ReadToMemory(saveInputStream, facePicSize, imgData)) {
			throw new RuntimeException("read img file to memory failed!");
		}
		sIn.sfaceImgData.imgData = imgData;
		sIn.sfaceImgData.imgLen = (int) facePicSize;
		sIn.sfaceImgData.imgHeight = 256;
		sIn.sfaceImgData.imgWidth = 256;
		Memory lpInBuffer = new Memory(sIn.size());
		CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
		Memory lpOutBuffer = new Memory(100 * 1024);
		//Pointer lpBytesReturned = new Memory(4);
		IntByReference lpBytesReturned = new IntByReference();
		boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 13, lpInBuffer, (int) lpInBuffer.size(),
				lpOutBuffer, (int) lpOutBuffer.size(), lpBytesReturned);
		if (!bResult) {
			throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
		}
		
		NET_SDK_SEARCH_IMAGE_BY_IMAGE_LIST sOut = new NET_SDK_SEARCH_IMAGE_BY_IMAGE_LIST();
		CommonFunctions.GetPointerDataToStruct(lpOutBuffer, 0, sOut);
		
	    /*NET_SDK_SEARCH_IMAGE_BY_IMAGE_LIST sOut = new NET_SDK_SEARCH_IMAGE_BY_IMAGE_LIST(lpOutBuffer,0);*/
		
		System.out.println(String.format("获取图片列表==> bEnd：%s, listNum:%s", sOut.bEnd, sOut.listNum));
		
		NET_SDK_SEARCH_IMAGE_ITEM[] items = new NET_SDK_SEARCH_IMAGE_ITEM[sOut.listNum];
		for (int i = 0; i < items.length; i++) {
			items[i] = new NET_SDK_SEARCH_IMAGE_ITEM();
		}
		CommonFunctions.GetPointerDataToStructArr(sOut.pSearchImageItem, items);
		
		
		/*int offset = 0;
		NET_SDK_SEARCH_IMAGE_ITEM[] items = new NET_SDK_SEARCH_IMAGE_ITEM[sOut.listNum];
		for (int i = 0; i < items.length; i++) {
			  items[i]= new NET_SDK_SEARCH_IMAGE_ITEM(sOut.pSearchImageItem,offset);
	          offset += items[i].size();
		}
		*/
		
		for (NET_SDK_SEARCH_IMAGE_ITEM item : items) {
			System.out.println(String.format("获取图片==> imgId:%s", item.sfaceImg.snapImgId));
			Pointer p = item.getPointer();
			Native.free(Pointer.nativeValue(p));//手动释放内存  
			Pointer.nativeValue(p, 0);
		}
		
		Native.free(Pointer.nativeValue(lpInBuffer));//手动释放内存  
		Pointer.nativeValue(lpInBuffer, 0);
		
		Native.free(Pointer.nativeValue(lpOutBuffer));//手动释放内存  
		Pointer.nativeValue(lpOutBuffer, 0);
		
//		Native.free(Pointer.nativeValue(lpBytesReturned));//手动释放内存  
//		Pointer.nativeValue(lpBytesReturned, 0);
		
		
		Pointer p = sOut.getPointer();
		Native.free(Pointer.nativeValue(p));//手动释放内存  
		Pointer.nativeValue(p, 0);
		
	}
}
